<?php

/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */
/** @var app\models\LoginForm $model */

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;

$this->title = 'Авторизация';
$this->params['breadcrumbs'][] = $this->title;
?>
    <div class="auth-container">
        <div class="row justify-content-center align-items-center min-vh-80">
            <div class="col-xl-5 col-lg-6 col-md-8">
                <!-- Карточка авторизации -->
                <div class="card auth-card border-0 shadow-lg rounded-4">
                    <div class="card-body p-5">
                        <!-- Заголовок -->
                        <div class="text-center mb-5">
                            <div class="auth-icon mb-4">
                                <div class="icon-wrapper bg-primary rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                    <i class="fas fa-sign-in-alt text-white" style="font-size: 2rem;"></i>
                                </div>
                            </div>
                            <h1 class="h2 fw-bold text-dark mb-2">С возвращением!</h1>
                            <p class="text-muted">Войдите в свой аккаунт чтобы продолжить</p>
                        </div>

                        <?php $form = ActiveForm::begin([
                            'id' => 'login-form',
                            'fieldConfig' => [
                                'template' => "{label}\n{input}\n{error}",
                                'labelOptions' => ['class' => 'form-label fw-semibold text-dark mb-2'],
                                'inputOptions' => ['class' => 'form-control form-control-lg py-3'],
                                'errorOptions' => ['class' => 'invalid-feedback d-block'],
                            ],
                            'options' => [
                                'class' => 'auth-form'
                            ]
                        ]); ?>

                        <!-- Поле логина -->
                        <div class="mb-4">
                            <?= $form->field($model, 'login', [
                                'options' => ['class' => 'form-floating']
                            ])->textInput([
                                'autofocus' => true,
                                'placeholder' => 'Логин',
                                'class' => 'form-control form-control-lg py-3 rounded-3'
                            ])->label('Логин') ?>
                            <div class="form-icon">
                                <i class="fas fa-user text-muted"></i>
                            </div>
                        </div>

                        <!-- Поле пароля -->
                        <div class="mb-4">
                            <?= $form->field($model, 'password', [
                                'options' => ['class' => 'form-floating']
                            ])->passwordInput([
                                'placeholder' => 'Пароль',
                                'class' => 'form-control form-control-lg py-3 rounded-3 password-input'
                            ])->label('Пароль') ?>
                            <div class="form-icon">
                                <i class="fas fa-lock text-muted"></i>
                            </div>
                            <button type="button" class="btn btn-link password-toggle" style="position: absolute; right: 15px; top: 50%; transform: translateY(-50%); z-index: 5;">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>

                        <!-- Дополнительные опции -->
                        <div class="mb-4">
                            <?= $form->field($model, 'rememberMe')->checkbox([
                                'template' => "<div class=\"form-check\">{input} {label}</div>\n<div class=\"text-danger\">{error}</div>",
                                'class' => 'form-check-input',
                                'labelOptions' => ['class' => 'form-check-label text-muted']
                            ]) ?>
                        </div>

                        <!-- Кнопка входа -->
                        <div class="d-grid mb-4">
                            <?= Html::submitButton('<i class="fas fa-sign-in-alt me-2"></i>Войти в аккаунт', [
                                'class' => 'btn btn-primary btn-lg py-3 fw-semibold rounded-3 shadow',
                                'name' => 'login-button'
                            ]) ?>
                        </div>

                        <?php ActiveForm::end(); ?>

                        <!-- Разделитель -->
                        <div class="divider d-flex align-items-center my-4">
                            <div class="border-top flex-grow-1"></div>
                            <div class="px-3 text-muted small">или</div>
                            <div class="border-top flex-grow-1"></div>
                        </div>

                        <!-- Ссылка на регистрацию -->
                        <div class="text-center">
                            <p class="text-muted mb-0">Еще не зарегистрированы?</p>
                            <a href="<?= \yii\helpers\Url::to(['site/register']) ?>" class="btn btn-outline-primary btn-lg rounded-3 px-4 mt-3">
                                <i class="fas fa-user-plus me-2"></i>Создать аккаунт
                            </a>
                        </div>

                        <!-- Дополнительные ссылки -->
                        <div class="text-center mt-4 pt-3 border-top">
                            <a href="<?= Yii::$app->homeUrl ?>" class="text-muted text-decoration-none">
                                <i class="fas fa-arrow-left me-1"></i>Вернуться на главную
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Декоративные элементы -->
                <div class="auth-decoration">
                    <div class="decoration-circle decoration-circle-1"></div>
                    <div class="decoration-circle decoration-circle-2"></div>
                    <div class="decoration-circle decoration-circle-3"></div>
                </div>
            </div>
        </div>
    </div>

<?php
$this->registerCss(<<<CSS
    .min-vh-80 {
        min-height: 80vh;
        padding: 2rem 0;
    }
    
    .auth-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
        position: relative;
        z-index: 2;
    }
    
    .auth-container {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        position: relative;
        overflow: hidden;
    }
    
    .auth-icon {
        transition: transform 0.3s ease;
    }
    
    .auth-card:hover .auth-icon {
        transform: scale(1.05);
    }
    
    /* Стили для полей формы */
    .form-floating {
        position: relative;
    }
    
    .form-floating > .form-control {
        padding-left: 3rem;
        border: 2px solid #e9ecef;
        transition: all 0.3s ease;
    }
    
    .form-floating > .form-control:focus {
        border-color: #4361ee;
        box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
    }
    
    .form-icon {
        position: absolute;
        left: 1rem;
        top: 50%;
        transform: translateY(-50%);
        z-index: 4;
        font-size: 1.1rem;
    }
    
    .form-floating > label {
        padding-left: 3rem;
        z-index: 3;
    }
    
    /* Переключатель видимости пароля */
    .password-toggle {
        color: #6c757d;
        text-decoration: none;
        border: none;
        background: none;
    }
    
    .password-toggle:hover {
        color: #4361ee;
    }
    
    /* Чекбокс */
    .form-check-input:checked {
        background-color: #4361ee;
        border-color: #4361ee;
    }
    
    .form-check-input:focus {
        border-color: #4361ee;
        box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
    }
    
    /* Кнопки */
    .btn-primary {
        background: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
        border: none;
        transition: all 0.3s ease;
    }
    
    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(67, 97, 238, 0.3) !important;
    }
    
    .btn-outline-primary {
        border: 2px solid #4361ee;
        color: #4361ee;
        transition: all 0.3s ease;
    }
    
    .btn-outline-primary:hover {
        background: #4361ee;
        border-color: #4361ee;
        transform: translateY(-2px);
    }
    
    /* Разделитель */
    .divider .border-top {
        border-top-color: #dee2e6 !important;
    }
    
    /* Декоративные элементы */
    .auth-decoration {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        pointer-events: none;
        z-index: 1;
    }
    
    .decoration-circle {
        position: absolute;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.1);
        animation: float 6s ease-in-out infinite;
    }
    
    .decoration-circle-1 {
        width: 100px;
        height: 100px;
        top: 10%;
        left: 10%;
        animation-delay: 0s;
    }
    
    .decoration-circle-2 {
        width: 150px;
        height: 150px;
        top: 60%;
        right: 10%;
        animation-delay: 2s;
    }
    
    .decoration-circle-3 {
        width: 70px;
        height: 70px;
        bottom: 20%;
        left: 20%;
        animation-delay: 4s;
    }
    
    /* Анимации */
    @keyframes float {
        0%, 100% { 
            transform: translateY(0px) rotate(0deg); 
        }
        50% { 
            transform: translateY(-20px) rotate(180deg); 
        }
    }
    
    /* Анимация появления формы */
    .auth-card {
        animation: slideUpFade 0.8s ease-out;
    }
    
    @keyframes slideUpFade {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    /* Адаптивность */
    @media (max-width: 768px) {
        .auth-card {
            margin: 1rem;
            padding: 2rem 1.5rem !important;
        }
        
        .btn-lg {
            padding: 0.75rem 1.5rem;
        }
        
        .display-4 {
            font-size: 2rem;
        }
    }
    
    /* Кастомный скроллбар */
    ::-webkit-scrollbar {
        width: 8px;
    }
    
    ::-webkit-scrollbar-track {
        background: #f1f1f1;
    }
    
    ::-webkit-scrollbar-thumb {
        background: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
        border-radius: 10px;
    }
CSS
);

$this->registerJs(<<<JS
    // Переключение видимости пароля
    $(document).on('click', '.password-toggle', function() {
        const passwordInput = $(this).closest('.form-floating').find('.password-input');
        const icon = $(this).find('i');
        
        if (passwordInput.attr('type') === 'password') {
            passwordInput.attr('type', 'text');
            icon.removeClass('fa-eye').addClass('fa-eye-slash');
        } else {
            passwordInput.attr('type', 'password');
            icon.removeClass('fa-eye-slash').addClass('fa-eye');
        }
    });
    
    // Анимация при фокусе на поля
    $('.form-control').on('focus', function() {
        $(this).closest('.form-floating').find('.form-icon').css('color', '#4361ee');
    }).on('blur', function() {
        $(this).closest('.form-floating').find('.form-icon').css('color', '#6c757d');
    });
JS
);
?>