<?php

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;

$this->title = 'Формирование заявки';
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="application-form-container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10">
                <!-- Карточка формы -->
                <div class="card application-card border-0 shadow-lg rounded-4">
                    <div class="card-body p-5">
                        <!-- Заголовок -->
                        <div class="text-center mb-5">
                            <div class="application-icon mb-4">
                                <div class="icon-wrapper bg-primary rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                    <i class="fas fa-file-alt text-white" style="font-size: 2rem;"></i>
                                </div>
                            </div>
                            <h1 class="h2 fw-bold text-dark mb-2">Формирование заявки</h1>
                            <p class="text-muted">Заполните форму для подачи заявки на обучение</p>
                        </div>

                        <!-- Информационные карточки -->
                        <div class="row mb-5">
                            <div class="col-md-4">
                                <div class="info-card text-center p-3 rounded-3 bg-light border">
                                    <div class="info-icon mb-2">
                                        <i class="fas fa-clock text-primary fs-4"></i>
                                    </div>
                                    <small class="text-muted">Рассмотрение заявки занимает 1-2 рабочих дня</small>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="info-card text-center p-3 rounded-3 bg-light border">
                                    <div class="info-icon mb-2">
                                        <i class="fas fa-shield-alt text-success fs-4"></i>
                                    </div>
                                    <small class="text-muted">Все данные защищены и конфиденциальны</small>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="info-card text-center p-3 rounded-3 bg-light border">
                                    <div class="info-icon mb-2">
                                        <i class="fas fa-headset text-info fs-4"></i>
                                    </div>
                                    <small class="text-muted">Поддержка 24/7 по всем вопросам</small>
                                </div>
                            </div>
                        </div>

                        <?php $form = ActiveForm::begin([
                            'id' => 'application-form',
                            'fieldConfig' => [
                                'template' => "{label}\n{input}\n{error}",
                                'labelOptions' => ['class' => 'form-label fw-semibold text-dark mb-3'],
                                'inputOptions' => ['class' => 'form-control form-control-lg py-3'],
                                'errorOptions' => ['class' => 'invalid-feedback d-block mt-2'],
                            ],
                            'options' => [
                                'class' => 'application-form'
                            ]
                        ]); ?>

                        <!-- Поле названия курса -->
                        <div class="mb-4">
                            <div class="form-floating">
                                <?= $form->field($model, 'title')->textInput([
                                    'autofocus' => true,
                                    'placeholder' => ' ',
                                    'class' => 'form-control form-control-lg py-3 rounded-3'
                                ])->label('Название курса') ?>
                                <div class="form-icon">
                                    <i class="fas fa-book text-muted"></i>
                                </div>
                            </div>
                            <div class="form-text text-muted mt-2">
                                <small>Укажите полное название выбранного курса обучения</small>
                            </div>
                        </div>

                        <!-- Поле даты -->
                        <div class="mb-4">
                            <div class="form-floating">
                                <?= $form->field($model, 'date')->textInput([
                                    'type' => 'date',
                                    'placeholder' => ' ',
                                    'class' => 'form-control form-control-lg py-3 rounded-3 date-input'
                                ])->label('Желаемая дата начала') ?>
                                <div class="form-icon">
                                    <i class="fas fa-calendar-alt text-muted"></i>
                                </div>
                            </div>
                            <div class="form-text text-muted mt-2">
                                <small>Выберите удобную дату для начала обучения</small>
                            </div>
                        </div>

                        <!-- Поле способа оплаты -->
                        <div class="mb-5">
                            <div class="form-floating">
                                <?= $form->field($model, 'pay')->dropDownList([
                                    '0' => 'Наличными',
                                    '1' => 'Переводом по номеру телефона'
                                ], [
                                    'class' => 'form-select form-select-lg py-3 rounded-3',
                                    'prompt' => 'Выберите способ оплаты'
                                ])->label('Способ оплаты') ?>
                                <div class="form-icon">
                                    <i class="fas fa-credit-card text-muted"></i>
                                </div>
                            </div>
                            <div class="form-text text-muted mt-2">
                                <small>Выберите предпочтительный способ оплаты обучения</small>
                            </div>
                        </div>

                        <!-- Информация о выборе -->
                        <div class="selection-preview mb-4 p-4 bg-light rounded-3 border" style="display: none;">
                            <h6 class="fw-bold mb-3">Предварительный просмотр заявки:</h6>
                            <div class="row">
                                <div class="col-md-4">
                                    <small class="text-muted d-block">Курс:</small>
                                    <strong id="preview-title" class="text-dark">-</strong>
                                </div>
                                <div class="col-md-4">
                                    <small class="text-muted d-block">Дата начала:</small>
                                    <strong id="preview-date" class="text-dark">-</strong>
                                </div>
                                <div class="col-md-4">
                                    <small class="text-muted d-block">Оплата:</small>
                                    <strong id="preview-pay" class="text-dark">-</strong>
                                </div>
                            </div>
                        </div>

                        <!-- Кнопка отправки -->
                        <div class="d-grid mb-4">
                            <?= Html::submitButton('<i class="fas fa-paper-plane me-2"></i>Отправить заявку на рассмотрение', [
                                'class' => 'btn btn-primary btn-lg py-3 fw-semibold rounded-3 shadow',
                                'name' => 'application-button',
                                'id' => 'submit-btn'
                            ]) ?>
                        </div>

                        <?php ActiveForm::end(); ?>

                        <!-- Дополнительная информация -->
                        <div class="additional-info mt-5 pt-4 border-top">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6 class="fw-bold mb-3">Что будет после отправки:</h6>
                                    <ul class="list-unstyled text-muted">
                                        <li class="mb-2">
                                            <i class="fas fa-check-circle text-success me-2"></i>
                                            Заявка поступит на рассмотрение
                                        </li>
                                        <li class="mb-2">
                                            <i class="fas fa-check-circle text-success me-2"></i>
                                            Вы получите уведомление по email
                                        </li>
                                        <li class="mb-2">
                                            <i class="fas fa-check-circle text-success me-2"></i>
                                            С вами свяжется менеджер для уточнения деталей
                                        </li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h6 class="fw-bold mb-3">Нужна помощь?</h6>
                                    <div class="d-flex flex-column gap-2">
                                        <a href="#" class="text-decoration-none text-primary">
                                            <i class="fas fa-phone me-2"></i>+7 (999) 123-45-67
                                        </a>
                                        <a href="#" class="text-decoration-none text-primary">
                                            <i class="fas fa-envelope me-2"></i>support@koro4ki-est.ru
                                        </a>
                                        <a href="#" class="text-decoration-none text-primary">
                                            <i class="fas fa-question-circle me-2"></i>Часто задаваемые вопросы
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Ссылка назад -->
                        <div class="text-center mt-4 pt-3">
                            <a href="<?= \yii\helpers\Url::to(['application/index']) ?>" class="text-muted text-decoration-none">
                                <i class="fas fa-arrow-left me-1"></i>Вернуться к моим заявкам
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$this->registerCss(<<<CSS
    .application-form-container {
        padding: 2rem 0;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        min-height: 100vh;
    }
    
    .application-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
    }
    
    .application-icon {
        transition: transform 0.3s ease;
    }
    
    .application-card:hover .application-icon {
        transform: scale(1.05);
    }
    
    .info-card {
        transition: all 0.3s ease;
        height: 100%;
    }
    
    .info-card:hover {
        transform: translateY(-5px);
        background: white !important;
        border-color: #4361ee !important;
    }
    
    /* Стили для полей формы */
    .form-floating {
        position: relative;
    }
    
    .form-floating > .form-control,
    .form-floating > .form-select {
        padding-left: 3rem;
        border: 2px solid #e9ecef;
        transition: all 0.3s ease;
    }
    
    .form-floating > .form-control:focus,
    .form-floating > .form-select:focus {
        border-color: #4361ee;
        box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
    }
    
    .form-icon {
        position: absolute;
        left: 1rem;
        top: 50%;
        transform: translateY(-50%);
        z-index: 4;
        font-size: 1.1rem;
    }
    
    .form-floating > label {
        padding-left: 3rem;
        z-index: 3;
    }
    
    /* Кастомный селект */
    .form-select {
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 1rem center;
        background-size: 16px 12px;
    }
    
    /* Превью заявки */
    .selection-preview {
        transition: all 0.3s ease;
        background: linear-gradient(135deg, #f8f9ff 0%, #f0f2ff 100%);
        border: 2px dashed #4361ee !important;
    }
    
    /* Кнопки */
    .btn-primary {
        background: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
        border: none;
        transition: all 0.3s ease;
    }
    
    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(67, 97, 238, 0.3) !important;
    }
    
    /* Анимации */
    @keyframes slideInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .application-card {
        animation: slideInUp 0.8s ease-out;
    }
    
    /* Кастомная дата */
    .date-input::-webkit-calendar-picker-indicator {
        background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%236c757d' viewBox='0 0 16 16'%3E%3Cpath d='M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4H1z'/%3E%3C/svg%3E");
        cursor: pointer;
        padding: 0.3rem;
        border-radius: 3px;
    }
    
    .date-input::-webkit-calendar-picker-indicator:hover {
        background-color: #f8f9fa;
    }
    
    /* Адаптивность */
    @media (max-width: 768px) {
        .application-card {
            margin: 1rem;
            padding: 2rem 1.5rem !important;
        }
        
        .btn-lg {
            padding: 0.75rem 1.5rem;
        }
        
        .h2 {
            font-size: 1.75rem;
        }
        
        .info-card {
            margin-bottom: 1rem;
        }
        
        .additional-info .row > div {
            margin-bottom: 2rem;
        }
    }
    
    /* Валидация */
    .is-invalid {
        border-color: #dc3545 !important;
    }
    
    .is-valid {
        border-color: #28a745 !important;
    }
    
    /* Плавные переходы */
    .form-control, .form-select {
        transition: all 0.3s ease;
    }
CSS
);

$this->registerJs(<<<JS
    // Обновление превью заявки
    function updatePreview() {
        const title = $('#applicationform-title').val();
        const date = $('#applicationform-date').val();
        const pay = $('#applicationform-pay option:selected').text();
        
        if (title || date || pay !== 'Выберите способ оплаты') {
            $('.selection-preview').fadeIn(300);
            $('#preview-title').text(title || '-');
            $('#preview-date').text(date ? new Date(date).toLocaleDateString('ru-RU') : '-');
            $('#preview-pay').text(pay !== 'Выберите способ оплаты' ? pay : '-');
        } else {
            $('.selection-preview').fadeOut(300);
        }
    }
    
    // Слушатели изменений полей
    $('#applicationform-title, #applicationform-date, #applicationform-pay').on('input change', function() {
        updatePreview();
        
        // Анимация при изменении
        $(this).css('transform', 'scale(1.02)');
        setTimeout(() => {
            $(this).css('transform', 'scale(1)');
        }, 150);
    });
    
    // Анимация при фокусе на поля
    $('.form-control, .form-select').on('focus', function() {
        $(this).closest('.form-floating').find('.form-icon').css('color', '#4361ee');
    }).on('blur', function() {
        $(this).closest('.form-floating').find('.form-icon').css('color', '#6c757d');
    });
    
    // Валидация формы
    $('#application-form').on('submit', function(e) {
        const pay = $('#applicationform-pay').val();
        if (pay === '') {
            e.preventDefault();
            $('#applicationform-pay').focus();
            $('#applicationform-pay').addClass('is-invalid');
            
            // Анимация ошибки
            $('#applicationform-pay').css('transform', 'translateX(10px)');
            setTimeout(() => {
                $('#applicationform-pay').css('transform', 'translateX(0)');
            }, 300);
        }
    });
    
    // Убрать ошибку при выборе способа оплаты
    $('#applicationform-pay').on('change', function() {
        if ($(this).val() !== '') {
            $(this).removeClass('is-invalid');
        }
    });
    
    // Инициализация превью при загрузке
    $(document).ready(function() {
        updatePreview();
    });
JS
);
?>