<?php

use app\models\Application;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;

/** @var yii\web\View $this */
/** @var app\models\ApplicationSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = Yii::t('app', 'Управление заявками');
$this->params['breadcrumbs'][] = $this->title;
?>
    <div class="application-admin-container">
        <!-- Заголовок с статистикой -->
        <div class="d-flex justify-content-between align-items-center mb-5">
            <div>
                <h1 class="display-5 fw-bold text-dark mb-2"><?= Html::encode($this->title) ?></h1>
                <p class="text-muted fs-5">Панель управления всеми заявками системы</p>
            </div>
            <div class="text-end">
                <div class="btn-group">
                    <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown">
                        <i class="fas fa-download me-2"></i>Экспорт
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="#"><i class="fas fa-file-excel me-2"></i>Excel</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-file-pdf me-2"></i>PDF</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-file-csv me-2"></i>CSV</a></li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Статистика -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="stat-card bg-primary text-white rounded-4 p-4 shadow">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="fw-bold mb-1"><?= $dataProvider->totalCount ?></h3>
                            <p class="mb-0 opacity-90">Всего заявок</p>
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-file-alt fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card bg-warning text-white rounded-4 p-4 shadow">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="fw-bold mb-1"><?= Application::find()->where(['status' => 0])->count() ?></h3>
                            <p class="mb-0 opacity-90">Новые</p>
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-clock fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card bg-info text-white rounded-4 p-4 shadow">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="fw-bold mb-1"><?= Application::find()->where(['status' => 1])->count() ?></h3>
                            <p class="mb-0 opacity-90">В процессе</p>
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-sync-alt fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card bg-success text-white rounded-4 p-4 shadow">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="fw-bold mb-1"><?= Application::find()->where(['status' => 2])->count() ?></h3>
                            <p class="mb-0 opacity-90">Завершено</p>
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-check-circle fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Таблица заявок -->
        <div class="card border-0 rounded-4 shadow">
            <div class="card-header bg-transparent border-0 p-4">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0 fw-bold">
                        <i class="fas fa-list me-2 text-primary"></i>Список заявок
                    </h5>
                    <div class="table-actions">
                        <button class="btn btn-sm btn-outline-secondary" id="refresh-table">
                            <i class="fas fa-sync-alt"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body p-0">
                <?php Pjax::begin(['id' => 'application-grid-pjax', 'timeout' => 5000]); ?>
                <?= GridView::widget([
                    'dataProvider' => $dataProvider,
                    'filterModel' => $searchModel,
                    'tableOptions' => ['class' => 'table table-hover table-striped mb-0'],
                    'layout' => "{items}\n<div class='table-pagination p-4'>{pager}</div>",
                    'pager' => [
                        'options' => ['class' => 'pagination justify-content-center'],
                        'linkOptions' => ['class' => 'page-link'],
                        'disabledListItemSubTagOptions' => ['tag' => 'a', 'class' => 'page-link'],
                    ],
                    'columns' => [
                        [
                            'class' => 'yii\grid\SerialColumn',
                            'header' => '#',
                            'headerOptions' => ['class' => 'text-center fw-semibold'],
                            'contentOptions' => ['class' => 'text-center fw-bold text-primary']
                        ],
                        [
                            'attribute' => 'title',
                            'headerOptions' => ['class' => 'fw-semibold'],
                            'contentOptions' => ['class' => 'fw-semibold'],
                            'filterInputOptions' => [
                                'class' => 'form-control form-control-sm',
                                'placeholder' => 'Поиск по названию...'
                            ]
                        ],
                        [
                            'attribute' => 'date',
                            'headerOptions' => ['class' => 'fw-semibold'],
                            'contentOptions' => ['class' => 'text-nowrap'],
                            'format' => 'date',
                            'filterInputOptions' => [
                                'class' => 'form-control form-control-sm',
                                'type' => 'date'
                            ]
                        ],
                        [
                            'attribute' => 'status',
                            'headerOptions' => ['class' => 'fw-semibold'],
                            'contentOptions' => function($model) {
                                $classes = [
                                    0 => 'badge bg-warning',
                                    1 => 'badge bg-info',
                                    2 => 'badge bg-success'
                                ];
                                return ['class' => $classes[$model->status] ?? 'badge bg-secondary'];
                            },
                            'value' => function($model) {
                                return $model->getStatus();
                            },
                            'filter' => [
                                0 => 'Новая',
                                1 => 'Идет обучение',
                                2 => 'Обучение завершено'
                            ],
                            'filterInputOptions' => [
                                'class' => 'form-select form-select-sm',
                                'prompt' => 'Все статусы'
                            ]
                        ],
                        [
                            'attribute' => 'pay',
                            'headerOptions' => ['class' => 'fw-semibold'],
                            'contentOptions' => function($model) {
                                return ['class' => 'badge bg-light text-dark border'];
                            },
                            'value' => function($model) {
                                return $model->getPay();
                            },
                            'filter' => [
                                0 => 'Наличными',
                                1 => 'Переводом по номеру телефона'
                            ],
                            'filterInputOptions' => [
                                'class' => 'form-select form-select-sm',
                                'prompt' => 'Все способы оплаты'
                            ]
                        ],
                        [
                            'attribute' => 'user_id',
                            'headerOptions' => ['class' => 'fw-semibold'],
                            'value' => 'user.login',
                            'filterInputOptions' => [
                                'class' => 'form-control form-control-sm',
                                'placeholder' => 'Поиск по логину...'
                            ]
                        ],
                        [
                            'class' => ActionColumn::className(),
                            'template' => '{update} {delete}',
                            'header' => 'Действия',
                            'headerOptions' => ['class' => 'text-center fw-semibold'],
                            'contentOptions' => ['class' => 'text-center'],
                            'buttons' => [
                                'update' => function ($url, $model, $key) {
                                    return Html::a('<i class="fas fa-edit"></i>', $url, [
                                        'class' => 'btn btn-sm btn-outline-primary me-1',
                                        'title' => 'Редактировать',
                                        'data-pjax' => 0
                                    ]);
                                },
                                'delete' => function ($url, $model, $key) {
                                    return Html::a('<i class="fas fa-trash"></i>', $url, [
                                        'class' => 'btn btn-sm btn-outline-danger',
                                        'title' => 'Удалить',
                                        'data' => [
                                            'confirm' => 'Вы уверены, что хотите удалить эту заявку?',
                                            'method' => 'post',
                                        ],
                                        'data-pjax' => 0
                                    ]);
                                },
                            ],
                            'urlCreator' => function ($action, Application $model, $key, $index, $column) {
                                return Url::toRoute([$action, 'id' => $model->id]);
                            }
                        ],
                    ],
                    'options' => [
                        'class' => 'table-responsive'
                    ]
                ]); ?>
                <?php Pjax::end(); ?>
            </div>
        </div>

        <!-- Быстрые действия -->
        <div class="row mt-4">
            <div class="col-md-6">
                <div class="card border-0 rounded-4 shadow-sm">
                    <div class="card-body">
                        <h6 class="card-title fw-bold mb-3">
                            <i class="fas fa-bolt me-2 text-warning"></i>Быстрые действия
                        </h6>
                        <div class="d-flex flex-wrap gap-2">
                            <a href="<?= Url::to(['application/create']) ?>" class="btn btn-success btn-sm">
                                <i class="fas fa-plus me-1"></i>Новая заявка
                            </a>
                            <button class="btn btn-warning btn-sm" id="mark-processed">
                                <i class="fas fa-play me-1"></i>В процесс
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card border-0 rounded-4 shadow-sm">
                    <div class="card-body">
                        <h6 class="card-title fw-bold mb-3">
                            <i class="fas fa-chart-bar me-2 text-primary"></i>Статистика за сегодня
                        </h6>
                        <div class="row text-center">
                            <div class="col-4">
                                <div class="text-success fw-bold fs-5"><?= Application::find()->where(['>=', 'date', date('Y-m-d')])->count() ?></div>
                                <small class="text-muted">Новых</small>
                            </div>
                            <div class="col-4">
                                <div class="text-primary fw-bold fs-5"><?= Application::find()->where(['status' => 1])->andWhere(['>=', 'date', date('Y-m-d')])->count() ?></div>
                                <small class="text-muted">В работе</small>
                            </div>
                            <div class="col-4">
                                <div class="text-info fw-bold fs-5"><?= Application::find()->where(['status' => 2])->andWhere(['>=', 'date', date('Y-m-d')])->count() ?></div>
                                <small class="text-muted">Завершено</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$this->registerCss(<<<CSS
    .application-admin-container {
        padding: 2rem 0;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        min-height: 100vh;
    }
    
    .stat-card {
        transition: all 0.3s ease;
        height: 100%;
    }
    
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.15) !important;
    }
    
    .stat-icon {
        opacity: 0.8;
        transition: opacity 0.3s ease;
    }
    
    .stat-card:hover .stat-icon {
        opacity: 1;
    }
    
    /* Стили таблицы */
    .table {
        margin-bottom: 0;
    }
    
    .table th {
        border-top: none;
        font-weight: 600;
        color: #495057;
        background-color: #f8f9fa;
        padding: 1rem 0.75rem;
    }
    
    .table td {
        padding: 1rem 0.75rem;
        vertical-align: middle;
        border-color: #f1f3f4;
    }
    
    .table-hover tbody tr:hover {
        background-color: rgba(67, 97, 238, 0.05);
        transform: scale(1.01);
        transition: all 0.2s ease;
    }
    
    .table-striped tbody tr:nth-of-type(odd) {
        background-color: rgba(0, 0, 0, 0.02);
    }
    
    /* Бейджи */
    .badge {
        font-size: 0.75rem;
        font-weight: 500;
        padding: 0.35em 0.65em;
    }
    
    /* Пагинация */
    .table-pagination {
        background-color: #f8f9fa;
        border-top: 1px solid #dee2e6;
    }
    
    .page-link {
        border: none;
        color: #4361ee;
        margin: 0 2px;
        border-radius: 6px;
    }
    
    .page-item.active .page-link {
        background: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
        border: none;
    }
    
    /* Карточки быстрых действий */
    .card {
        transition: all 0.3s ease;
    }
    
    .card:hover {
        transform: translateY(-2px);
    }
    
    /* Анимации */
    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }
    
    .table tbody tr {
        animation: fadeIn 0.5s ease-out;
    }
    
    /* Адаптивность */
    @media (max-width: 768px) {
        .application-admin-container {
            padding: 1rem;
        }
        
        .display-5 {
            font-size: 2rem;
        }
        
        .stat-card {
            margin-bottom: 1rem;
        }
        
        .table-responsive {
            font-size: 0.875rem;
        }
        
        .btn-group {
            width: 100%;
            margin-top: 1rem;
        }
        
        .d-flex.justify-content-between {
            flex-direction: column;
            text-align: center;
        }
    }
    
    /* Кастомные тени */
    .shadow {
        box-shadow: 0 5px 20px rgba(0,0,0,0.12) !important;
    }
    
    .shadow-sm {
        box-shadow: 0 2px 10px rgba(0,0,0,0.08) !important;
    }
    
    /* Кнопки действий */
    .btn-sm {
        border-radius: 6px;
        transition: all 0.3s ease;
    }
    
    .btn-sm:hover {
        transform: translateY(-1px);
    }
CSS
);

$this->registerJs(<<<JS
    // Обновление таблицы
    $('#refresh-table').on('click', function() {
        $.pjax.reload({container: '#application-grid-pjax'});
        $(this).find('i').addClass('fa-spin');
        setTimeout(() => {
            $(this).find('i').removeClass('fa-spin');
        }, 1000);
    });
    
    // Подсветка строк при наведении
    $('.table tbody tr').on('mouseenter', function() {
        $(this).css('transform', 'scale(1.01)');
    }).on('mouseleave', function() {
        $(this).css('transform', 'scale(1)');
    });
    
    // Анимация загрузки
    $(document).on('pjax:send', function() {
        $('.table-responsive').css('opacity', '0.7');
    });
    
    $(document).on('pjax:complete', function() {
        $('.table-responsive').css('opacity', '1');
    });
    
    // Быстрые действия
    $('#export-selected').on('click', function() {
        toastr.info('Функция экспорта в разработке');
    });
    
    $('#mark-processed').on('click', function() {
        toastr.warning('Функция массового изменения в разработке');
    });
    
    $('#bulk-delete').on('click', function() {
        toastr.error('Функция массового удаления в разработке');
    });
    
    // Инициализация tooltips
    $(function () {
        $('[title]').tooltip();
    });
JS
);
?>