<?php

use yii\helpers\Html;

/** @var yii\web\View $this */
/** @var app\models\Application $model */

$this->title = Yii::t('app', 'Создание новой заявки');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Заявки'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
    <div class="application-create-container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10">
                <!-- Карточка создания заявки -->
                <div class="card create-card border-0 shadow-lg rounded-4">
                    <div class="card-body p-5">
                        <!-- Заголовок -->
                        <div class="text-center mb-5">
                            <div class="create-icon mb-4">
                                <div class="icon-wrapper bg-success rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                    <i class="fas fa-plus-circle text-white" style="font-size: 2rem;"></i>
                                </div>
                            </div>
                            <h1 class="h2 fw-bold text-dark mb-2">Создание новой заявки</h1>
                            <p class="text-muted">Заполните форму для создания новой заявки на обучение</p>
                        </div>

                        <!-- Процесс создания -->
                        <div class="creation-process mb-5">
                            <div class="row text-center">
                                <div class="col-md-4">
                                    <div class="process-step active">
                                        <div class="step-number bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3">
                                            1
                                        </div>
                                        <h6 class="fw-bold text-dark">Заполнение данных</h6>
                                        <small class="text-muted">Основная информация</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="process-step">
                                        <div class="step-number bg-light text-muted rounded-circle d-inline-flex align-items-center justify-content-center mb-3">
                                            2
                                        </div>
                                        <h6 class="fw-bold text-muted">Проверка</h6>
                                        <small class="text-muted">Подтверждение данных</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="process-step">
                                        <div class="step-number bg-light text-muted rounded-circle d-inline-flex align-items-center justify-content-center mb-3">
                                            3
                                        </div>
                                        <h6 class="fw-bold text-muted">Завершение</h6>
                                        <small class="text-muted">Создание заявки</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Информационные карточки -->
                        <div class="row mb-5">
                            <div class="col-md-6">
                                <div class="info-card bg-primary text-white rounded-4 p-4">
                                    <div class="d-flex align-items-center">
                                        <div class="info-icon me-3">
                                            <i class="fas fa-lightbulb fa-2x opacity-75"></i>
                                        </div>
                                        <div>
                                            <h6 class="fw-bold mb-1">Совет</h6>
                                            <p class="mb-0 small opacity-90">Заполняйте данные внимательно - это ускорит обработку заявки</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-card bg-light rounded-4 p-4">
                                    <div class="d-flex align-items-center">
                                        <div class="info-icon me-3">
                                            <i class="fas fa-clock text-warning fa-2x"></i>
                                        </div>
                                        <div>
                                            <h6 class="fw-bold mb-1 text-dark">Время обработки</h6>
                                            <p class="mb-0 small text-muted">Обычно занимает 1-2 рабочих дня</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Форма создания -->
                        <div class="create-form-section">
                            <div class="section-header mb-4">
                                <h4 class="fw-bold text-dark">
                                    <i class="fas fa-edit me-2 text-primary"></i>Основная информация
                                </h4>
                                <p class="text-muted mb-0">Заполните все необходимые поля для создания заявки</p>
                            </div>

                            <?= $this->render('_form', [
                                'model' => $model,
                            ]) ?>

                            <!-- Дополнительные настройки -->
                            <div class="additional-settings mt-4">
                                <div class="card border-0 bg-light">
                                    <div class="card-body">
                                        <h6 class="fw-bold text-dark mb-3">
                                            <i class="fas fa-cogs me-2 text-muted"></i>Дополнительные настройки
                                        </h6>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="emailNotifications" checked>
                                                    <label class="form-check-label text-muted" for="emailNotifications">
                                                        <i class="fas fa-envelope me-2"></i>Email уведомления
                                                    </label>
                                                </div>
                                                <div class="form-check mt-2">
                                                    <input class="form-check-input" type="checkbox" id="smsNotifications">
                                                    <label class="form-check-label text-muted" for="smsNotifications">
                                                        <i class="fas fa-sms me-2"></i>SMS уведомления
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="urgentProcessing">
                                                    <label class="form-check-label text-muted" for="urgentProcessing">
                                                        <i class="fas fa-bolt me-2"></i>Срочная обработка
                                                    </label>
                                                </div>
                                                <div class="form-check mt-2">
                                                    <input class="form-check-input" type="checkbox" id="consultationRequired" checked>
                                                    <label class="form-check-label text-muted" for="consultationRequired">
                                                        <i class="fas fa-phone me-2"></i>Требуется консультация
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Предпросмотр заявки -->
                            <div class="application-preview mt-4">
                                <div class="card border-0 bg-warning bg-opacity-10">
                                    <div class="card-body">
                                        <h6 class="fw-bold text-dark mb-3">
                                            <i class="fas fa-eye me-2 text-warning"></i>Предпросмотр заявки
                                        </h6>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <small class="text-muted d-block">Название курса:</small>
                                                <strong id="preview-title" class="text-dark">Не указано</strong>
                                            </div>
                                            <div class="col-md-4">
                                                <small class="text-muted d-block">Дата начала:</small>
                                                <strong id="preview-date" class="text-dark">Не указана</strong>
                                            </div>
                                            <div class="col-md-4">
                                                <small class="text-muted d-block">Способ оплаты:</small>
                                                <strong id="preview-pay" class="text-dark">Не выбран</strong>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Кнопки действий -->
                        <div class="action-buttons mt-5 pt-4 border-top">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="d-grid gap-2">
                                        <?= Html::submitButton('<i class="fas fa-plus-circle me-2"></i>Создать заявку', [
                                            'class' => 'btn btn-success btn-lg py-3 fw-semibold rounded-3 shadow',
                                            'form' => 'application-form'
                                        ]) ?>
                                        <small class="text-muted text-center mt-2">
                                            Нажимая кнопку, вы соглашаетесь с условиями обработки данных
                                        </small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="d-grid gap-2">
                                        <?= Html::a('<i class="fas fa-arrow-left me-2"></i>Вернуться к списку',
                                            ['index'],
                                            ['class' => 'btn btn-outline-secondary btn-lg py-3 fw-semibold rounded-3']
                                        ) ?>
                                        <?= Html::a('<i class="fas fa-times me-2"></i>Отменить создание',
                                            ['index'],
                                            ['class' => 'btn btn-outline-danger btn-lg py-3 fw-semibold rounded-3 mt-2']
                                        ) ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Дополнительная информация -->
                        <div class="additional-info mt-5">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="card border-0 bg-light">
                                        <div class="card-body">
                                            <h6 class="fw-bold text-dark mb-3">
                                                <i class="fas fa-question-circle me-2 text-primary"></i>Нужна помощь?
                                            </h6>
                                            <div class="d-flex flex-column gap-2">
                                                <a href="#" class="text-decoration-none text-primary">
                                                    <i class="fas fa-phone me-2"></i>+7 (999) 123-45-67
                                                </a>
                                                <a href="#" class="text-decoration-none text-primary">
                                                    <i class="fas fa-envelope me-2"></i>support@koro4ki-est.ru
                                                </a>
                                                <a href="#" class="text-decoration-none text-primary">
                                                    <i class="fas fa-comments me-2"></i>Онлайн-чат
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="card border-0 bg-light">
                                        <div class="card-body">
                                            <h6 class="fw-bold text-dark mb-3">
                                                <i class="fas fa-info-circle me-2 text-success"></i>Что дальше?
                                            </h6>
                                            <ul class="list-unstyled text-muted small">
                                                <li class="mb-1">
                                                    <i class="fas fa-check me-2 text-success"></i>Проверка данных менеджером
                                                </li>
                                                <li class="mb-1">
                                                    <i class="fas fa-check me-2 text-success"></i>Подтверждение заявки
                                                </li>
                                                <li class="mb-1">
                                                    <i class="fas fa-check me-2 text-success"></i>Начало обучения
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$this->registerCss(<<<CSS
    .application-create-container {
        padding: 2rem 0;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        min-height: 100vh;
    }
    
    .create-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
    }
    
    .create-icon {
        transition: transform 0.3s ease;
    }
    
    .create-card:hover .create-icon {
        transform: scale(1.05);
    }
    
    /* Процесс создания */
    .creation-process {
        position: relative;
    }
    
    .creation-process:before {
        content: '';
        position: absolute;
        top: 40px;
        left: 10%;
        right: 10%;
        height: 3px;
        background: #e9ecef;
        z-index: 1;
    }
    
    .process-step {
        position: relative;
        z-index: 2;
        transition: all 0.3s ease;
    }
    
    .process-step.active .step-number {
        transform: scale(1.1);
        box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
    }
    
    .step-number {
        width: 50px;
        height: 50px;
        font-weight: bold;
        font-size: 1.2rem;
        transition: all 0.3s ease;
    }
    
    .process-step:hover {
        transform: translateY(-5px);
    }
    
    /* Информационные карточки */
    .info-card {
        transition: all 0.3s ease;
        height: 100%;
        border: 1px solid rgba(0,0,0,0.05);
    }
    
    .info-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    /* Дополнительные настройки */
    .additional-settings .card {
        transition: all 0.3s ease;
    }
    
    .additional-settings .card:hover {
        transform: translateY(-2px);
    }
    
    .application-preview .card {
        border: 2px dashed #ffc107 !important;
        transition: all 0.3s ease;
    }
    
    .application-preview .card:hover {
        border-color: #fd7e14 !important;
        transform: translateY(-2px);
    }
    
    /* Чекбоксы */
    .form-check-input:checked {
        background-color: #4361ee;
        border-color: #4361ee;
    }
    
    .form-check-input:focus {
        border-color: #4361ee;
        box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.25);
    }
    
    /* Кнопки */
    .btn-success {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        border: none;
        transition: all 0.3s ease;
    }
    
    .btn-success:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(40, 167, 69, 0.3) !important;
    }
    
    .btn-outline-secondary, .btn-outline-danger {
        transition: all 0.3s ease;
        border-width: 2px;
    }
    
    .btn-outline-secondary:hover, .btn-outline-danger:hover {
        transform: translateY(-2px);
    }
    
    /* Анимации */
    @keyframes slideInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .create-card {
        animation: slideInUp 0.8s ease-out;
    }
    
    /* Секции */
    .section-header {
        border-bottom: 2px solid #f1f3f4;
        padding-bottom: 1rem;
    }
    
    .action-buttons {
        background: linear-gradient(135deg, #f8f9ff 0%, #ffffff 100%);
    }
    
    /* Адаптивность */
    @media (max-width: 768px) {
        .application-create-container {
            padding: 1rem;
        }
        
        .create-card {
            margin: 0;
            padding: 2rem 1.5rem !important;
        }
        
        .btn-lg {
            padding: 0.75rem 1.5rem;
        }
        
        .h2 {
            font-size: 1.75rem;
        }
        
        .action-buttons .row > div {
            margin-bottom: 1rem;
        }
        
        .creation-process:before {
            display: none;
        }
        
        .process-step {
            margin-bottom: 2rem;
        }
        
        .info-card {
            margin-bottom: 1rem;
        }
    }
    
    /* Дополнительные стили */
    .additional-info .card {
        transition: all 0.3s ease;
        height: 100%;
    }
    
    .additional-info .card:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
CSS
);

$this->registerJs(<<<JS
    // Обновление предпросмотра заявки
    function updatePreview() {
        const title = $('#application-title').val();
        const date = $('#application-date').val();
        const pay = $('#application-pay option:selected').text();
        
        $('#preview-title').text(title || 'Не указано');
        $('#preview-date').text(date ? new Date(date).toLocaleDateString('ru-RU') : 'Не указана');
        $('#preview-pay').text(pay !== 'Выберите способ оплаты' ? pay : 'Не выбран');
        
        // Анимация обновления
        $('.application-preview .card').css('transform', 'scale(1.02)');
        setTimeout(() => {
            $('.application-preview .card').css('transform', 'scale(1)');
        }, 200);
    }
    
    // Слушатели изменений полей
    $('#application-title, #application-date, #application-pay').on('input change', function() {
        updatePreview();
        
        // Анимация при изменении
        $(this).css('transform', 'scale(1.02)');
        setTimeout(() => {
            $(this).css('transform', 'scale(1)');
        }, 150);
    });
    
    // Анимация при фокусе на поля
    $('.form-control, .form-select').on('focus', function() {
        $(this).closest('.form-group').find('.form-icon').css('color', '#4361ee');
        $(this).closest('.form-group').css('transform', 'translateX(5px)');
    }).on('blur', function() {
        $(this).closest('.form-group').find('.form-icon').css('color', '#6c757d');
        $(this).closest('.form-group').css('transform', 'translateX(0)');
    });
    
    // Анимация чекбоксов
    $('.form-check-input').on('change', function() {
        $(this).closest('.form-check').css('transform', 'scale(1.05)');
        setTimeout(() => {
            $(this).closest('.form-check').css('transform', 'scale(1)');
        }, 200);
    });
    
    // Валидация формы
    $('#application-form').on('submit', function(e) {
        let isValid = true;
        const title = $('#application-title').val();
        const date = $('#application-date').val();
        const pay = $('#application-pay').val();
        
        if (!title) {
            $('#application-title').addClass('is-invalid');
            isValid = false;
        }
        
        if (!date) {
            $('#application-date').addClass('is-invalid');
            isValid = false;
        }
        
        if (pay === '') {
            $('#application-pay').addClass('is-invalid');
            isValid = false;
        }
        
        if (!isValid) {
            e.preventDefault();
            // Анимация ошибки
            $('.is-invalid').css('transform', 'translateX(10px)');
            setTimeout(() => {
                $('.is-invalid').css('transform', 'translateX(0)');
            }, 300);
            
            // Показать уведомление
            toastr.error('Пожалуйста, заполните все обязательные поля');
        }
    });
    
    // Убрать ошибку при вводе
    $('.form-control, .form-select').on('input change', function() {
        if ($(this).val()) {
            $(this).removeClass('is-invalid');
        }
    });
    
    // Инициализация предпросмотра
    $(document).ready(function() {
        updatePreview();
    });
JS
);
?>