<?php

namespace app\models;

use Yii;
use yii\base\Model;

class ApplicationForm extends Model
{
    public $title;
    public $date;
    public $pay;


    /**
     * @return array the validation rules.
     */
    public function rules()
    {
        return [
            [['title', 'date', 'pay'], 'required'],
        ];
    }
    public function attributeLabels()
    {
        return [
            'title' => 'Наименование курса',
            'date' => 'Дата начала обучения',
            'pay' => 'Способ оплаты',
        ];
    }

    public function appSave()
    {
        if (!$this->validate()) {
            Yii::error('Validation failed: ' . print_r($this->errors, true));
            return false;
        }
        $application = new Application();
        $application->title = $this->title;
        $application->date = $this->date;
        $application->pay = $this->pay;
        $application->user_id = Yii::$app->user->identity->getId();
        $application->status = '0';
        if ($application->save()) {
            return true;
        } else {
            Yii::error('Save failed: ' . print_r($application->errors, true));
            return false;
        }
    }


}
