<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "application".
 *
 * @property int $id
 * @property string $title
 * @property string $date
 * @property string $status
 * @property string $pay
 * @property int $user_id
 *
 * @property Comment[] $comments
 * @property User $user
 */
class Application extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'application';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['title', 'date', 'status', 'pay', 'user_id'], 'required'],
            [['date'], 'safe'],
            [['user_id'], 'integer'],
            [['title', 'status', 'pay'], 'string', 'max' => 255],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['user_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'title' => Yii::t('app', 'Название'),
            'date' => Yii::t('app', 'Дата начала обучения'),
            'status' => Yii::t('app', 'Статус'),
            'pay' => Yii::t('app', 'Способ оплаты'),
            'user_id' => Yii::t('app', 'Пользователь'),
        ];
    }

    /**
     * Gets query for [[Comments]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getComments()
    {
        return $this->hasMany(Comment::class, ['application_id' => 'id']);
    }

    /**
     * Gets query for [[User]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

    public function getPay(){
        if ($this->pay == 0){
            return 'Наличными';
        } elseif ($this->pay == 1){
            return 'Переводом по номеру телефона';
        }
        return null;
    }

    public function getStatus(){
        if ($this->status == 0){
            return 'Новая';
        } elseif ($this->status == 1){
            return 'Идет обучение';
        } elseif ($this->status == 2){
            return 'Обучение завершено';
        }
        return null;
    }
}
