<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%application}}`.
 */
class m251009_120809_create_application_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%application}}', [
            'id' => $this->primaryKey(),
            'title' => $this->string()->notNull(),
            'date' => $this->date()->notNull(),
            'status' => $this->string()->notNull(),
            'pay' => $this->string()->notNull(),
            'user_id' => $this->integer()->notNull(),
        ]);
        $this->addForeignKey(
            'fk-application-user_id',
            'application',
            'user_id',
            'user',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%application}}');
    }
}
